<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class EquivalenceUnite extends Model 
{

    protected $table = 'equivalences_unites';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('id_uniteDepart', 'id_uniteArrive', 'valeur', 'statut');
    protected $visible = array('slug', 'id_uniteDepart', 'id_uniteArrive', 'valeur', 'statut');

    public function unite()
    {
        return $this->belongsTo('App\Models\Unite', 'id_uniteDepart');
    }

}